<?php
/*
	Class For creating a progress bar, using gd image library

	Created by:	Lee Findlow
	Contact:	lee@findlow.info
	Website:	http://findlow.info
	Current Version: 0.13
	
//CHANGELOG
	09/07/2007 - Main Class Created
	10/07/2007 - Added "Timeline" Functions (User, Friends, Public)
	11/07/2007 - Added "User Methods" Functions
	12/07/2007 - Fixed some bugs
	
*/
class twitter{
	//Variables
		//Authentication
		var $Username;	//Username
		var $Password;	//Password
	//Twitter Settings
		var $MaxLength = 160;	//Maximum length of post
	//Variables Used
		var $Show	= array();	//Detail from last Show() Query
		var $ShowUser	= array();
		var $FriendTimeline	= array();	//Stores friend timeline
		var $UserTimeline	= array();	//Stores user timeline
		var $PublicTimeline	= array();	//Stores public timeline
		//USER METHODS
			var $UserFriends = array();	//Friends list
			var $UserFollowers = array();	//Followers list
			var $UserFeatured = array();	//Featured list

	//Twitter URL's
		var $URLupdate	= 'http://twitter.com/statuses/update.xml?status={STATUS}';	//URL For posting to twitter
		var $URLdestroy	= 'http://twitter.com/statuses/destroy/{ID}.xml';	//URL for Destroying Post
		var $URLshow	= 'http://twitter.com/statuses/show/{ID}.xml';	//URL to display single post
		var $URLusershow	= 'http://twitter.com/users/show/{NAME}.xml';	//URL for displaying user information
		var $URLfriendtimeline	= 'http://twitter.com/statuses/friends_timeline.xml'; //URL for friend timeline
		var $URLusertimeline	= 'http://twitter.com/statuses/user_timeline.xml'; //URL for user timeline
		var $URLpublictimeline	= 'http://twitter.com/statuses/public_timeline.xml'; //URL for user timeline
			//USER METHODS
				var $URLuserfriends = 'http://twitter.com/statuses/friends.xml';	//URL of users friend list
				var $URLuserfollowers	= 'http://twitter.com/statuses/followers.xml';	//URL of users followers list
				var $URLuserfeatured	= 'http://twitter.com/statuses/featured.xml';	//URL of featured users
	
	//Begin Main Functions
	
	//Update Status
	function Status($Status = ''){
		if(empty($this->Username) || empty($this->Password)){
			$this->Error(1);
		} else{
			//Check $Status is set & less than 160 chars
			if(!empty($Status) && strlen($Status) <= $this->MaxLength){
				//Check CURL library is installed
				if(function_exists(curl_init)){
					//Continue
					//Initialise Curl
					$ch = curl_init();
					//Set CURL options
						//Prepare URL
						$URLupdate = str_replace('{STATUS}', urlencode(stripslashes(urldecode($Status))), $this->URLupdate);
					curl_setopt($ch, CURLOPT_URL, $URLupdate);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
					curl_setopt($ch, CURLOPT_USERPWD, "$this->Username:$this->Password");
					curl_setopt($ch, CURLOPT_POST, true);
					//Execute Query
					curl_exec($ch);
					//Response Headers
					$Headers = curl_getinfo($ch);
					//DEBUG - display response headers
							//print_r($Headers);
					//Close CURL session
					curl_close($ch);
						//Check for 200 Status
						if($Headers['http_code'] == 200){
							return 1;
						} else{
							//Find out problem
							if($Headers['http_code'] == 401){
								//Wrong username/password
								$this->Error(4);
							} elseif($Headers['http_code'] == 404){
								//Invalid URL
								$this->Error(5);
							}
						}//Check Response
				} else{
					$this->Error(2);
				}//CURL Library installed
			} else{
				$this->Error(3);
			}//$Status too long/empty
		}//Username & Password set
	}//End Update()
	
	//Show Single Post
	//All information is stored in $this->Show Array
	function Show($id = ''){
		if(!empty($id) && is_integer($id)){
			if(function_exists(curl_init)){
				//Continue
				//Initialise Curl
				$ch = curl_init();
				//Set CURL options
					//Prepare URL
					$URLshow = str_replace('{ID}', $id, $this->URLshow);
				curl_setopt($ch, CURLOPT_URL, $URLshow);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				//Execute Query
				$Response = curl_exec($ch);
				//DEBUG - Display Response
					//echo $Response;
				//Response Headers
				$Headers = curl_getinfo($ch);
					//Parse XML response data
					$xml = xml_parser_create();
					xml_parse_into_struct($xml, $Response, $vals, $index);
					//Create Data Array
					$status = array();
					$status['created_at'] = $vals[$index['CREATED_AT'][0]]['value'];
					$status['id'] = $vals[$index['ID'][0]]['value'];
					$status['text'] = $vals[$index['TEXT'][0]]['value'];
					$status['user']['id'] = $vals[$index['ID'][1]]['value'];
					$status['user']['name'] = $vals[$index['NAME'][0]]['value'];
					$status['user']['screen_name'] = $vals[$index['SCREEN_NAME'][0]]['value'];
					$status['user']['location'] = $vals[$index['LOCATION'][0]]['value'];
					$status['user']['description'] = $vals[$index['DESCRIPTION'][0]]['value'];
					$status['user']['profile_image_url'] = $vals[$index['PROFILE_IMAGE_URL'][0]]['value'];
					$status['user']['url'] = $vals[$index['URL'][0]]['value'];
					$status['user']['protected'] = $vals[$index['PROTECTED'][0]]['value'];
					$this->Show = $status;
					return $Status;
				//DEBUG - display response headers
						//print_r($Headers);
				//Close CURL session
				curl_close($ch);
					//Check for 200 Status
					if($Headers['http_code'] == 200){
						//Everything is OK, return post
						//Parse XML response data
						$xml = xml_parser_create();
						xml_parse_into_struct($xml, $Response, $vals, $index);
						//Create Data Array
						$status = array();
						$status['created_at'] = $vals[$index['CREATED_AT'][0]]['value'];
						$status['id'] = $vals[$index['ID'][0]]['value'];
						$status['text'] = $vals[$index['TEXT'][0]]['value'];
						$status['user']['id'] = $vals[$index['ID'][1]]['value'];
						$status['user']['name'] = $vals[$index['NAME'][0]]['value'];
						$status['user']['screen_name'] = $vals[$index['SCREEN_NAME'][0]]['value'];
						$status['user']['location'] = $vals[$index['LOCATION'][0]]['value'];
						$status['user']['description'] = $vals[$index['DESCRIPTION'][0]]['value'];
						$status['user']['profile_image_url'] = $vals[$index['PROFILE_IMAGE_URL'][0]]['value'];
						$status['user']['url'] = $vals[$index['URL'][0]]['value'];
						$status['user']['protected'] = $vals[$index['PROTECTED'][0]]['value'];
						$this->Show = $status;
						return 1;
					} else{
						//Find out problem
						if($Headers['http_code'] == 401){
							//Wrong username/password
							$this->Error(4);
						} elseif($Headers['http_code'] == 404){
							//Invalid URL
							$this->Error(5);
						}
					}//Check Response
			} else{
				$this->Error(2);
			}//CURL Library installed
		} else{
			$this->Error(6);
		}//End Check $id is valid
	}
	
	//Function to get details of user, either by username or ID
	function ShowUser($Name = ''){
		if(empty($this->Username) || empty($this->Password)){
			$this->Error(1);
		} else{
			if(!empty($Name)){
				if(function_exists(curl_init)){
					//Continue
					//Initialise Curl
					$ch = curl_init();
					//Set CURL options
						//Prepare URL
						$URLusershow = str_replace('{NAME}', $Name, $this->URLusershow);
					curl_setopt($ch, CURLOPT_URL, $URLusershow);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
					curl_setopt($ch, CURLOPT_USERPWD, "$this->Username:$this->Password");
					curl_setopt($ch, CURLOPT_POST, true);
					//Execute Query
					$Response = curl_exec($ch);
					//DEBUG - Display Response
						//echo $Response;
					//Response Headers
					$Headers = curl_getinfo($ch);
					//DEBUG - display response headers
							//print_r($Headers);
					//Close CURL session
					curl_close($ch);
						//Check for 200 Status
						if($Headers['http_code'] == 200){
							//Check that there are no errors
							if($Response == 'You are not authorized to see this user.'){
								$this->Error(7);
							} else{
								//Parse XML into Array
								$xml = xml_parser_create();
								xml_parse_into_struct($xml, $Response, $vals, $index);
										//print_r($index);
										//print_r($vals);
								//Create Data Array
										//echo $Response;
								//Put user detail into Array
								foreach($index as $key => $val){
									$user[strtolower($key)] = $vals[$index[$key][0]]['value'];
								}
									$this->ShowUser = $user;
									return 1;
							}
						} else{
							//Find out problem
							if($Headers['http_code'] == 401){
								//Wrong username/password
								$this->Error(4);
							} elseif($Headers['http_code'] == 404){
								//Invalid URL
								$this->Error(5);
							}
						}//Check Response
				} else{
					$this->Error(2);
				}//CURL Library installed
			} else{
				$this->Error(6);
			}//Check $Name is entered
		}//Check Username & Password are entered
	}//End UserShow
	
	//Function to destroy status
	function Destroy($id = ''){
		if(empty($this->Username) || empty($this->Password)){
			$this->Error(1);
		} else{
			//Check $Status is set & less than 160 chars
			if(!empty($id) && is_integer($id)){
				//Check CURL libbrary is installed
				if(function_exists(curl_init)){
					//Continue
					//Initialise Curl
					$ch = curl_init();
					//Set CURL options
						//Prepare URL
						$URLdestroy = str_replace('{ID}', $id, $this->URLdestroy);
					curl_setopt($ch, CURLOPT_URL, $URLdestroy);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
					curl_setopt($ch, CURLOPT_USERPWD, "$this->Username:$this->Password");
					curl_setopt($ch, CURLOPT_POST, true);
					//Execute Query
					$Response = curl_exec($ch);
					//DEBUG - display http response
							//echo $Response;
					//Response Headers
					$Headers = curl_getinfo($ch);
					//DEBUG - display response headers
							//print_r($Headers);
					//Close CURL session
					curl_close($ch);
						//Check for 200 Status
						if($Headers['http_code'] == 200){
							return 1;
						} else{
							//Find out problem
							if($Headers['http_code'] == 401){
								//Wrong username/password
								$this->Error(4);
							} elseif($Headers['http_code'] == 404){
								//Invalid URL
								$this->Error(5);
							}
						}//Check Response
				} else{
					$this->Error(2);
				}//CURL Library installed
			} else{
				$this->Error(6);
			}//$Status too long/empty
		}//Username & Password set
	}//End Destroy
	
//USER METHODS

	//List users friends (returned as an array) (of logged in user)
	function UserFriends(){
		if(empty($this->Username) || empty($this->Password)){
			$this->Error(1);
		} else{
			//Check CURL libbrary is installed
			if(function_exists(curl_init)){
				//Continue
				//Initialise Curl
				$ch = curl_init();
				//Set CURL options
				curl_setopt($ch, CURLOPT_URL, $this->URLuserfriends);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_USERPWD, "$this->Username:$this->Password");
				curl_setopt($ch, CURLOPT_POST, true);
				//Execute Query
				$Response = curl_exec($ch);
					//DEBUG  - Display Response
						//echo $Response;
				//Response Headers
				$Headers = curl_getinfo($ch);
					//DEBUG - display response headers
						//print_r($Headers);
					//Parse Friend Timeline & store in FriendTimeline variable
					$this->ParseUserList($Response, 'UserFriends');
				//Close CURL session
				curl_close($ch);
					//Check for 200 Status
					if($Headers['http_code'] == 200){
						return 1;
					} else{
						//Find out problem
						if($Headers['http_code'] == 401){
							//Wrong username/password
							$this->Error(4);
						} elseif($Headers['http_code'] == 404){
							//Invalid URL
							$this->Error(5);
						}
					}//Check Response
			} else{
				$this->Error(2);
			}//CURL Library installed
		}//Username & Password set
	}//End UserFriends()
	
	//List users followers (returned as an array) (of logged in user)
	function UserFollowers(){
		if(empty($this->Username) || empty($this->Password)){
			$this->Error(1);
		} else{
			//Check CURL libbrary is installed
			if(function_exists(curl_init)){
				//Continue
				//Initialise Curl
				$ch = curl_init();
				//Set CURL options
				curl_setopt($ch, CURLOPT_URL, $this->URLuserfollowers);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_USERPWD, "$this->Username:$this->Password");
				curl_setopt($ch, CURLOPT_POST, true);
				//Execute Query
				$Response = curl_exec($ch);
					//DEBUG  - Display Response
						//echo $Response;
				//Response Headers
				$Headers = curl_getinfo($ch);
					//DEBUG - display response headers
						//print_r($Headers);
					//Parse Friend Timeline & store in FriendTimeline variable
					$this->ParseUserList($Response, 'UserFollowers');
				//Close CURL session
				curl_close($ch);
					//Check for 200 Status
					if($Headers['http_code'] == 200){
						return 1;
					} else{
						//Find out problem
						if($Headers['http_code'] == 401){
							//Wrong username/password
							$this->Error(4);
						} elseif($Headers['http_code'] == 404){
							//Invalid URL
							$this->Error(5);
						}
					}//Check Response
			} else{
				$this->Error(2);
			}//CURL Library installed
		}//Username & Password set
	}//End UserFollowers()

	//List users followers (returned as an array) (of logged in user)
	function UserFeatured(){
		//Check CURL libbrary is installed
		if(function_exists(curl_init)){
			//Continue
			//Initialise Curl
			$ch = curl_init();
			//Set CURL options
			curl_setopt($ch, CURLOPT_URL, $this->URLuserfeatured);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_USERPWD, "$this->Username:$this->Password");
			curl_setopt($ch, CURLOPT_POST, true);
			//Execute Query
			$Response = curl_exec($ch);
				//DEBUG  - Display Response
					//echo $Response;
			//Response Headers
			$Headers = curl_getinfo($ch);
				//DEBUG - display response headers
					//print_r($Headers);
				//Parse Friend Timeline & store in FriendTimeline variable
				$this->ParseUserList($Response, 'UserFeatured');
			//Close CURL session
			curl_close($ch);
				//Check for 200 Status
				if($Headers['http_code'] == 200){
					return 1;
				} else{
					//Find out problem
					if($Headers['http_code'] == 401){
						//Wrong username/password
						$this->Error(4);
					} elseif($Headers['http_code'] == 404){
						//Invalid URL
						$this->Error(5);
					}
				}//Check Response
		} else{
			$this->Error(2);
		}//CURL Library installed
	}//End UserFeatured()

	
//END USER METHODS
	
	//Friend timeline - 20 most recent posts of user & their friends from last 24 hours
	function FriendTimeline(){
		if(empty($this->Username) || empty($this->Password)){
			$this->Error(1);
		} else{
			//Check CURL libbrary is installed
			if(function_exists(curl_init)){
				//Continue
				//Initialise Curl
				$ch = curl_init();
				//Set CURL options
				curl_setopt($ch, CURLOPT_URL, $this->URLfriendtimeline);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_USERPWD, "$this->Username:$this->Password");
				curl_setopt($ch, CURLOPT_POST, true);
				//Execute Query
				$Response = curl_exec($ch);
					//DEBUG  - Display Response
						//echo $Response;
				//Response Headers
				$Headers = curl_getinfo($ch);
					//DEBUG - display response headers
						//print_r($Headers);
					//Parse Friend Timeline & store in FriendTimeline variable
					$this->ParseTimeline($Response, 'FriendTimeline');
				//Close CURL session
				curl_close($ch);
					//Check for 200 Status
					if($Headers['http_code'] == 200){
					} else{
						//Find out problem
						if($Headers['http_code'] == 401){
							//Wrong username/password
							$this->Error(4);
						} elseif($Headers['http_code'] == 404){
							//Invalid URL
							$this->Error(5);
						}
					}//Check Response
			} else{
				$this->Error(2);
			}//CURL Library installed
		}//Username & Password set
	}//End FriendTimeline()

	//User timeline - 20 most recent posts of user from last 24 hours
	function UserTimeline(){
		if(empty($this->Username) || empty($this->Password)){
			$this->Error(1);
		} else{
			//Check CURL libbrary is installed
			if(function_exists(curl_init)){
				//Continue
				//Initialise Curl
				$ch = curl_init();
				//Set CURL options
				curl_setopt($ch, CURLOPT_URL, $this->URLusertimeline);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_USERPWD, "$this->Username:$this->Password");
				curl_setopt($ch, CURLOPT_POST, true);
				//Execute Query
				$Response = curl_exec($ch);
					//DEBUG  - Display Response
						//echo $Response;
				//Response Headers
				$Headers = curl_getinfo($ch);
					//DEBUG - display response headers
						//print_r($Headers);
					//Parse Friend Timeline & store in FriendTimeline variable
					$this->ParseTimeline($Response, 'UserTimeline');
				//Close CURL session
				curl_close($ch);
					//Check for 200 Status
					if($Headers['http_code'] == 200){
					} else{
						//Find out problem
						if($Headers['http_code'] == 401){
							//Wrong username/password
							$this->Error(4);
						} elseif($Headers['http_code'] == 404){
							//Invalid URL
							$this->Error(5);
						}
					}//Check Response
			} else{
				$this->Error(2);
			}//CURL Library installed
		}//Username & Password set
	}//End UserTimeline()

	//Public timeline - 20 most recent posts of all user's
	function PublicTimeline(){
		//Check CURL libbrary is installed
		if(function_exists(curl_init)){
			//Continue
			//Initialise Curl
			$ch = curl_init();
			//Set CURL options
			curl_setopt($ch, CURLOPT_URL, $this->URLpublictimeline);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_USERPWD, "$this->Username:$this->Password");
			curl_setopt($ch, CURLOPT_POST, true);
			//Execute Query
			$Response = curl_exec($ch);
				//DEBUG  - Display Response
					//echo $Response;
			//Response Headers
			$Headers = curl_getinfo($ch);
				//DEBUG - display response headers
					//print_r($Headers);
				//Parse Friend Timeline & store in FriendTimeline variable
				$this->ParseTimeline($Response, 'PublicTimeline');
			//Close CURL session
			curl_close($ch);
				//Check for 200 Status
				if($Headers['http_code'] == 200){
				} else{
					//Find out problem
					if($Headers['http_code'] == 401){
						//Wrong username/password
						$this->Error(4);
					} elseif($Headers['http_code'] == 404){
						//Invalid URL
						$this->Error(5);
					}
				}//Check Response
		} else{
			$this->Error(2);
		}//CURL Library installed
	}//End PublicTimeline()

	//Parse a list of users
	function ParseUserList($List, $StoreIn){
		if(!empty($List) && !empty($StoreIn)){
			$xml = xml_parser_create();
			xml_parse_into_struct($xml, $List, $vals, $index);
				//print_r($index);
				//print_r($vals);
			//Variables for making array
			$Users = count($index['CREATED_AT']);
			//Construct Array
			$List = array();
				/*EG
				$User[$i]['id'];
				$User[$i]['name'];
				$User[$i]['screen_name'];
				$User[$i]['location'];
				$User[$i]['description'];
				$User[$i]['profile_image_url'];
				$User[$i]['url'];
				$User[$i]['protected'];
				$User[$i]['status']['created_at'];
				$User[$i]['status']['id'];
				$User[$i]['status']['text'];
				*/
			$i = 0;
			$id = 0;
			$sid = 1;
			while($i < $Users){
				$user[$i]['id'] = $vals[$index['ID'][$id]]['value'];
					$id+=2;
				$user[$i]['name'] = $vals[$index['NAME'][$i]]['value'];
				$user[$i]['screen_name'] = $vals[$index['SCREEN_NAME'][$i]]['value'];
				$user[$i]['location'] = $vals[$index['LOCATION'][$i]]['value'];
				$user[$i]['description'] = $vals[$index['DESCRIPTION'][$i]]['value'];
				$user[$i]['profile_image_url'] = $vals[$index['PROFILE_IMAGE_URL'][$i]]['value'];
				$user[$i]['url'] = $vals[$index['URL'][$i]]['value'];
				$user[$i]['protected'] = $vals[$index['PROTECTED'][$i]]['value'];
				//Status
				$user[$i]['status']['created_at'] = $vals[$index['CREATED_AT'][$i]]['value'];
				$user[$i]['status']['id'] = $vals[$index['ID'][($id-1)]]['value'];
				$user[$i]['status']['text'] = $vals[$index['TEXT'][$i]]['value'];
			$i++;
			}
				//Save Timeline
				$this->{$StoreIn} = $user;
		} else{
			$this->Error(8);
		}
	}//End ParseUserList()
	
	//Parse timeline into array, and store in set variable
	function ParseTimeline($Timeline, $StoreIn){
		if(!empty($Timeline) && !empty($StoreIn)){
			$xml = xml_parser_create();
			xml_parse_into_struct($xml, $Timeline, $vals, $index);
				//print_r($index);
				//print_r($vals);
			//Variables for making array
			$Statuses = count($index['CREATED_AT']);
			//Construct Array
			$Timeline = array();
				/*EG
				$Timeline[$i]['created_at'];
				$Timeline[$i]['id'];
				$Timeline[$i]['text'];
				$Timeline[$i]['user']['id'];
				$Timeline[$i]['user']['name'];
				$Timeline[$i]['user']['screen_name'];
				$Timeline[$i]['user']['location'];
				$Timeline[$i]['user']['description'];
				$Timeline[$i]['user']['profile_image_url'];
				$Timeline[$i]['user']['url'];
				$Timeline[$i]['user']['protected';*/
			$i = 0;
			$id = 0;
			$uid = 1;
			while($i < $Statuses){
				//$i represents where to find the current created_at value
				//also a counter for the statuses
				$Timeline[$i]['created_at'] = $vals[$index['CREATED_AT'][$i]]['value'];
					//$id is the counter for getting the ID value
				$Timeline[$i]['id'] = $vals[$index['ID'][$id]]['value'];
					$id+=2;
				$Timeline[$i]['text'] = $vals[$index['TEXT'][$i]]['value'];
				//User Details
					//$uid stores location of User ID
				$Timeline[$i]['user']['id'] = $vals[$index['ID'][$uid]]['value'];
					$uid+=2;
				$Timeline[$i]['user']['name'] = $vals[$index['NAME'][$i]]['value'];
				$Timeline[$i]['user']['screen_name'] = $vals[$index['SCREEN_NAME'][$i]]['value'];
				$Timeline[$i]['user']['location'] = $vals[$index['LOCATION'][$i]]['value'];
				$Timeline[$i]['user']['description'] = $vals[$index['DESCRIPTION'][$i]]['value'];
				$Timeline[$i]['user']['profile_image_url'] = $vals[$index['PROFILE_IMAGE_URL'][$i]]['value'];
				$Timeline[$i]['user']['url'] = $vals[$index['URL'][$i]]['value'];
				$Timeline[$i]['user']['protected'] = $vals[$index['PROTECTED'][$i]]['value'];
			$i++;
			}
				//Save Timeline
				$this->{$StoreIn} = $Timeline;
		} else{
			$this->Error(8);
		}
	}//End ParseTimeline
	
	//Function to be called if error occurs
	function Error($Error){
		//List of Errors
		$e[1] = 'Username and/or password not set';
		$e[2] = 'CURL library not installed';
		$e[3] = 'Post value too long/not set';
		$e[4] = 'Invalid username/password';
		$e[5] = 'Invalud URL for CURL request';
		$e[6] = 'Invalid ID value entered';
		$e[7] = 'You are not authorized to view this page';
		$e[8] = 'All variables for requested function not set';
		//Display Error
		if(array_key_exists($Error, $e)){
			echo $e[$Error];
		} else{
			echo 'Invalid Error Code';
		}
	}//End Error()
};

?>