<?php
require_once('error_handler.php');
require_once('snipear/code/snipear'.$G_phpextension);
require_once('snipear/code/standard'.$G_phpextension);
require_once('snipear/code/additional'.$G_phpextension);
require_once('snipear/code/functions'.$G_phpextension);
require_once('snipear/code/system'.$G_phpextension);
require_once('snipear/code/dataaccess'.$G_phpextension);
require_once('snipear/code/corecode/coredb'.$G_phpextension);
require_once('snipear/code/logging'.$G_phpextension);
require_once('snipear/code/classes/class.tdownload'.$G_phpextension);
require_once('class.tsecuritylayer'.$G_phpextension);
require_once('class.tftmebasepage'.$G_phpextension);
require_once('class.tfilestogetherME'.$G_phpextension);

class TDownloadfolder extends TFTMEBasePage{

  function __construct($name='', $boolpersist=false, $needslogon=true){
  	parent::__construct($name, $boolpersist, $needslogon);
    $this->use_translations=true;
    $this->trans->usedb=false;
    $this->initialization();
  	$this->style_sheet_path="stylesheets";
  	$this->client_side_script_path="clientsidescript";

  	//*****************************************************************************
  	//The next 4 lines is required to be called here to maintain security...
  	//on normal pages it would just be called as part of the paint() method
  	//*****************************************************************************

  	//$this->checkpermissions();
  	$this->security_layer->controller='ftme'.$this->G_phpextension;
  	$this->security_layer->logonpage='easylogon'.$this->G_phpextension;

  	//******************************************************************************
  	//end of security layer
  	//******************************************************************************

  	$folderpath = fix_foldername($_GET['contextfolderpath']);

  	$TFileList = new TFTMEFileList('_TFileList');
  	$TFileList->drivearray = $this->drivearray;

  	$realpath = $TFileList->get_real_path_from_vpath($folderpath);

  	//create a temporary zip file of the folder
  	$nameprefix="fd_";
  	$tmpfname = tempnam("/tmp", $nameprefix);
  	if ($tmpfname===false){
  	  die ("Error creating temporary file for zip download");
  	}

  	//delete the temporary file
  	unlink($tmpfname);

  	$type='';

  	if (!iswindows()){
  	  $type='gz';
  	}

  	//create our archive class
  	$tar = new TArchive($tmpfname,$type);
  	if (iswindows()){
  	  $tar->iszip=true; //download as a .zip file
  	}else{
  	  $tar->iszip=false;
  	}

  	//create the array of the folder that is to be added
  	$dirarray=array($realpath);

  	//get the base os path as we need to remove this
  	$basepath=$realpath;

  	//print $folderpath."<br>".$basepath;
  	//die;

  	$parr=array('no_compression' => false,
  				'add_path' => $folderpath,
  				'remove_path' => $basepath,
  				'remove_all_path' => false);

  	//create the archive
  	$tar->create($dirarray, $parr);

  	//create the download filename
  	$namepath=str_ireplace("/", "_", $folderpath);

  	if (iswindows()){
  	  $namepath=$namepath.'.zip';
  	}else{
  	  $namepath=$namepath.'.tar.gz';
  	}

  	//download the zip file
  	$x = new TDownload();
  	$x->filename=$namepath;
  	$x->filepath=$tmpfname;
  	$x->gethtml();

  	//finally remove the temporary file
  	unlink($tmpfname);

  }
}

?>
