<?php
/**
* Delete file dialog for filestogether application
*
* @author   R&D <dev@anywheretogether.com>
* @package Files Together
* @version  1.0.0.0 25/03/2006
* @websites www.anywheretogether.com/www.filestogether.com
*/
require_once('error_handler.php');
require_once('snipear/code/standard'.$G_phpextension);
require_once('snipear/code/additional'.$G_phpextension);
require_once('snipear/code/functions'.$G_phpextension);
require_once('snipear/code/system'.$G_phpextension);
require_once('snipear/code/dataaccess'.$G_phpextension);
require_once('snipear/code/corecode/coredb'.$G_phpextension);
require_once('snipear/code/logging'.$G_phpextension);
require_once('snipear/code/classes/class.tdownload'.$G_phpextension);
require_once('class.tsecuritylayer'.$G_phpextension);
require_once('class.tftmebasepage'.$G_phpextension);
require_once('class.tfilestogetherME'.$G_phpextension);
require_once('class.tftdb'.$G_phpextension);

class Tdelete extends TFTMEBasePage{

  public $vpath;
  public $btn_submit;
  public $filepath;
  public $TFileList;

  function __construct($name='', $boolpersist=false, $needslogon=true){
  	parent::__construct($name, $boolpersist, $needslogon);

  	$this->title='Delete file';

   	//set up the form event
   	$this->frm_event->value='file_delete';


  	$this->filepath= stripslashes($_REQUEST['filepath']);
    $toplbl=new TLabel('toplbl');
  	$toplbl->proparray['class']='tlabel_header';
    $toplbl->caption='Delete File';

  	$this->titletable->addtocell('1cell1' , $toplbl);

  	//Build filelist  Object
  	$this->TFileList=new TFTMEFileList('_TFileList');
  	$this->TFileList->drivearray=$this->drivearray;
  	$this->vpath=$this->filepath;
  	$this->filepath=$this->TFileList->get_real_path_from_vpath($this->filepath);

    $maintable=new TSimpleTable("maintable");
    $maintable->proparray['border']='0';
    $maintable->proparray['width']='245';
  	$maintable->proparray['align']='left';
    $maintable->cellpadding=0;
    $maintable->cellspacing=3;

  	//message
  	$lbl_ftd = new TLabel('lbl_ftd');
  	$lbl_ftd->caption='File to delete:';
  	$maintable->addtocell('2cell1' , $lbl_ftd);


  	$ed_filename = new THtmlEdit('ed_filepath');
  	$ed_filename->value=$this->vpath;
  	$ed_filename->readonly=true;
  	$ed_filename->disabled=true;
  	$ed_filename->width=200;
  	$maintable->addtocell('3cell1' , $ed_filename);

  	$ed_filenameh = new THidden('filepath');
  	$ed_filenameh->value=$this->vpath;
  	$this->addobject($ed_filenameh);

  	$this->btn_submit->caption='Confirm Delete';
  	$maintable->addtocell('4cell1' , $this->btn_submit);

  	$maintable->addtocell('5cell1' , $this->btn_cancel);

  	$maintable->rows = 5;
  	$maintable->cols = 1;
    $maintable->tdproparray['align']='left';

  	$this->headertable->addtocell('2cell1' , $maintable);

  }
  function file_delete($sender){
    $vpath=$_REQUEST['filepath'];
  	$this->filepath=$this->TFileList->get_real_path_from_vpath($vpath);
    if (!DeleteFile($this->filepath)){
      $errlbl=new TErrorLabel('err');
      $errlbl->caption='errfiledelfail';//File delete failed
    	$this->headertable->rows=$this->headertable->rows+1;
      $this->headertable->addtocell($this->headertable->rows.'cell1' , $errlbl);
    }else{
      $link = "ftme".$this->G_phpextension."?drive=".urlencode($_SESSION['fdrive'])."&path=".urlencode($_SESSION['fpath']);
      OpenPage($link);
    }
  }
}
?>
