<?PHP
/*
Usage:

<?PHP
include '/path/to/mailq.php';
$SENDER_ID = 42;
mailq($to, $subject, $body, $headers);
?>
*/
require_once('mailq_config.php');


//$to can be an array of address strings
function Mailq($to,$subject,$body,$headers='') 
{
  global $SENDER_ID;
  global $db_options;
  global $mail_options;
  if(!$SENDER_ID) $SENDER_ID = -1;
  $hdrs = Headers_To_Array($headers);
  $hdrs['Subject'] = $subject;
  $from = $hdrs['From'];
  if(!$from) 
	{
    $from = $_SERVER['SERVER_ADMIN'];
    $hdrs['From'] = $from;
  }
  $mail_queue =& new Mail_Queue($db_options, $mail_options);
	
	if(is_array($to))
	{
foreach($to as $recipient)
		{
			$mail_queue->put( $from, $recipient, $hdrs, $body , 0, FALSE, $SENDER_ID);
		}
		return 1;
	}
	else
	{
		return $mail_queue->put( $from,$to, $hdrs, $body ,0,FALSE,$SENDER_ID);
	}
}

function Fold_Headers($headers) 
{
  global $CRLF;
  global $LWSP;
  return preg_replace("/$CRLF$LWSP+/"," ",$headers);
}

//Perpares headers for put()
function Headers_To_Array($headers) 
{
  global $CRLF;
  global $LWSP;
  $headers = Fold_Headers($headers);
  $array = preg_split("/$CRLF/",$headers,0,PREG_SPLIT_NO_EMPTY);
  for($i=0 ; $i != sizeof($array) ;++$i) 
	{
    $header_line = $array[$i];
    $header_array = preg_split("/:$LWSP+/",$header_line);
    $key = $header_array[0];
    $value = $header_array[1];
    $return_array[$key] = $value;
  }
  return $return_array;
}
?>